<?php

function check_extension($ext) {
    return extension_loaded($ext) ? 'Enabled' : 'Not Enabled';
}

function check_php_version($version) {
    return version_compare(PHP_VERSION, $version, '>=') ? 'Met' : 'Not Met';
}

$php_version_status = check_php_version('8.0');
$pdo_status = check_extension('pdo');
$curl_status = check_extension('curl');
$dom_status = check_extension('dom');
$openssl_status = check_extension('openssl');
$mbstring_status = check_extension('mbstring');
$exif_status = check_extension('exif');
$gd_status = check_extension('gd');
$pcre_status = check_extension('pcre');
$json_status = check_extension('json');
$fileinfo_status = check_extension('fileinfo');
$zip_status = check_extension('zip');

$required_status = [
    $php_version_status === 'Met',
    $pdo_status === 'Enabled',
    $curl_status === 'Enabled',
    $dom_status === 'Enabled',
    $openssl_status === 'Enabled',
    $mbstring_status === 'Enabled',
    $exif_status === 'Enabled',
    $gd_status === 'Enabled',
    $pcre_status === 'Enabled',
    $json_status === 'Enabled',
    $fileinfo_status === 'Enabled',
    $zip_status === 'Enabled'
];

$php_version_met = $php_version_status === 'Met';
$extensions_met = !in_array(false, $required_status);
$messages = [];
if (!$php_version_met) {
    $messages[] = 'Please change the PHP version to 8.1 or higher.';
}
if (!$extensions_met) {
    $messages[] = 'Please enable the required PHP extensions: ';
    $missing_extensions = [];
    foreach (['pdo', 'curl', 'dom', 'openssl', 'mbstring', 'exif', 'gd', 'pcre', 'json', 'fileinfo', 'zip'] as $ext) {
        if (check_extension($ext) === 'Not Enabled') {
            $missing_extensions[] = ucfirst($ext) . ' PHP Extension';
        }
    }
    $messages[] = implode(', ', $missing_extensions);
}

$message_class = $php_version_met && $extensions_met ? 'ready' : 'not-ready';
$message_text = $php_version_met && $extensions_met ? 'You are ready to go!' : implode(' ', $messages);

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Grupo System Requirements Check</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            color: #333;
        }
        .container {
            max-width: 800px;
            margin: 20px auto;
            padding: 20px;
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h1 {
            text-align: center;
            color: #333;
        }
        .checklist {
            margin: 20px 0;
            border-collapse: collapse;
            width: 100%;
        }
        .checklist th, .checklist td {
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        .checklist th {
            background-color: #f5f5f5;
        }
        .status-enabled {
            color: green;
        }
        .status-not-enabled {
            color: red;
        }
        .optional {
            color: #555;
        }
        .status {
            font-weight: bold;
        }
        .message {
            text-align: center;
            font-size: 1.2em;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 8px;
            margin-top: 20px;
        }
        .ready {
            background-color: #d4edda;
            color: #155724;
        }
        .not-ready {
            background-color: #f8d7da;
            color: #721c24;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>System Requirements Check</h1>
        <table class="checklist">
            <thead>
                <tr>
                    <th>Requirement</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>PHP Version (8.1 or higher)</td>
                    <td class="status <?php echo $php_version_status === 'Met' ? 'status-enabled' : 'status-not-enabled'; ?>"><?php echo $php_version_status; ?></td>
                </tr>
                <tr>
                    <td>PDO PHP Extension</td>
                    <td class="status <?php echo $pdo_status === 'Enabled' ? 'status-enabled' : 'status-not-enabled'; ?>"><?php echo $pdo_status; ?></td>
                </tr>
                <tr>
                    <td>cURL PHP Extension</td>
                    <td class="status <?php echo $curl_status === 'Enabled' ? 'status-enabled' : 'status-not-enabled'; ?>"><?php echo $curl_status; ?></td>
                </tr>
                <tr>
                    <td>DOM PHP Extension</td>
                    <td class="status <?php echo $dom_status === 'Enabled' ? 'status-enabled' : 'status-not-enabled'; ?>"><?php echo $dom_status; ?></td>
                </tr>
                <tr>
                    <td>OpenSSL PHP Extension</td>
                    <td class="status <?php echo $openssl_status === 'Enabled' ? 'status-enabled' : 'status-not-enabled'; ?>"><?php echo $openssl_status; ?></td>
                </tr>
                <tr>
                    <td>MBString PHP Extension</td>
                    <td class="status <?php echo $mbstring_status === 'Enabled' ? 'status-enabled' : 'status-not-enabled'; ?>"><?php echo $mbstring_status; ?></td>
                </tr>
                <tr>
                    <td>Exif PHP Extension</td>
                    <td class="status <?php echo $exif_status === 'Enabled' ? 'status-enabled' : 'status-not-enabled'; ?>"><?php echo $exif_status; ?></td>
                </tr>
                <tr>
                    <td>GD PHP Extension</td>
                    <td class="status <?php echo $gd_status === 'Enabled' ? 'status-enabled' : 'status-not-enabled'; ?>"><?php echo $gd_status; ?></td>
                </tr>
                <tr>
                    <td>PCRE PHP Extension</td>
                    <td class="status <?php echo $pcre_status === 'Enabled' ? 'status-enabled' : 'status-not-enabled'; ?>"><?php echo $pcre_status; ?></td>
                </tr>
                <tr>
                    <td>Json PHP Extension</td>
                    <td class="status <?php echo $json_status === 'Enabled' ? 'status-enabled' : 'status-not-enabled'; ?>"><?php echo $json_status; ?></td>
                </tr>
                <tr>
                    <td>FileInfo PHP Extension</td>
                    <td class="status <?php echo $fileinfo_status === 'Enabled' ? 'status-enabled' : 'status-not-enabled'; ?>"><?php echo $fileinfo_status; ?></td>
                </tr>
                <tr>
                    <td>Zip PHP Extension</td>
                    <td class="status <?php echo $zip_status === 'Enabled' ? 'status-enabled' : 'status-not-enabled'; ?>"><?php echo $zip_status; ?></td>
                </tr>
            </tbody>
        </table>

        <div class="message <?php echo $message_class; ?>">
            <?php echo $message_text; ?>
        </div>
    </div>
</body>
</html>
