<?php
namespace App;

/* This class is handling all the requests in the sso*/

class evolutionController{
   
    function __construct() {

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset(getallheaders()['authorization'])){
                if( getallheaders()['authorization'] != API_TOKEN ){
                    header('HTTP/1.0 403 Forbidden');
                    echo json_response([ 'error' => "wrong-token"]);
                    exit();
                }
            } else {
                header('HTTP/1.0 403 Forbidden');
                echo json_response([ 'error' => "missing-token"]);
                exit();
            }
        }

    }

    public function postmessage(){
        $jsondata = app('request')->body;
        $messageType = $jsondata['data']['messageType'];
        $messagedata = "";
        $datetime= date('Y-m-d H:i:s', $jsondata['data']['messageTimestamp']);
        $number = app('zapmsg')->normalizeBRNumber($jsondata['data']['key']['remoteJid']);
        $localID = 1000;
        if ($jsondata['data']['key']['fromMe'] == true ) $localID = 2000;
        switch($messageType) {
            case 'conversation':
                $messagedata = [
                    'number' => $number,
                    'localID' => $localID,
                    'date-time' => $datetime,
                    'message-id' => $jsondata['data']['key']['id'],
                    'message' => $jsondata['data']['message']['conversation']
                ];
                app('zapmsg')->processTextMessage($messagedata);
                return json_response( ['messageType' => $messageType , "status" => 'processed' ]);
            case 'imageMessage':
                $messagedata = [
                    'number' => $number,
                    'localID' => $localID,
                    'date-time' => $datetime,
                    'message-id' => $jsondata['data']['key']['id'],
                    'caption' => $jsondata['data']['message']['imageMessage']['caption'] ?? null,
                    'imageurl'=> $jsondata['data']['message']['imageMessage']['url'],
                    'imagekey'=> $jsondata['data']['message']['imageMessage']['mediaKey']
                ];
                app('zapmsg')->processImageMessage($messagedata);
                return json_response( ['messageType' => $messageType , "status" => 'processed' ]);
            case 'videoMessage':
                $messagedata = [
                    'number' => $number,
                    'localID' => $localID,
                    'date-time' => $datetime,
                    'message-id' => $jsondata['data']['key']['id'],
                    'caption' => $jsondata['data']['message']['videoMessage']['caption'] ?? null,
                    'videourl' => $jsondata['data']['message']['videoMessage']['url'],
                    'videokey' => $jsondata['data']['message']['videoMessage']['mediaKey'],
                    'videosec' => $jsondata['data']['message']['videoMessage']['seconds'],
                    'thumbjpg' => $jsondata['data']['message']['videoMessage']['jpegThumbnail'],
                    'filelength' => $jsondata['data']['message']['videoMessage']['fileLength'],
                    'mimetype' => $jsondata['data']['message']['videoMessage']['mimetype']
                ];
                app('zapmsg')->processVideoMessage($messagedata);
                return json_response( ['messageType' => $messageType , "status" => 'processed' ]);
            case 'audioMessage':
                $messagedata = [
                    'number' => $number,
                    'localID' => $localID,
                    'date-time' => $datetime,
                    'message-id' => $jsondata['data']['key']['id'],
                    'audiourl' => $jsondata['data']['message']['audioMessage']['url'],
                    'audiokey' => $jsondata['data']['message']['audioMessage']['mediaKey'],
                    'audiosec' => $jsondata['data']['message']['audioMessage']['seconds'],
                    'filelength' => $jsondata['data']['message']['audioMessage']['fileLength']
                ];
                app('zapmsg')->processAudioMessage($messagedata);
                return json_response( ['messageType' => $messageType , "status" => 'processed' ]);
            case 'documentMessage':
                $messagedata = [
                    'number' => $number,
                    'localID' => $localID,
                    'date-time' => $datetime,
                    'message-id' => $jsondata['data']['key']['id'],
                    'fileurl' => $jsondata['data']['message']['documentMessage']['url'],
                    'filekey' => $jsondata['data']['message']['documentMessage']['mediaKey'],
                    'filename' => $jsondata['data']['message']['documentMessage']['fileName'],
                    'filelength' => $jsondata['data']['message']['documentMessage']['fileLength']
                ];
                app('zapmsg')->processDocumentMessage($messagedata);
                return json_response( ['messageType' => $messageType , "status" => 'processed' ]);
        }
    }
    public function testreturn(){
       $returndata = app('deczap')->decryptImage('https://mmg.whatsapp.net/v/t62.7118-24/11848588_486641304416676_2515910129681412072_n.enc?ccb=11-4&oh=01_Q5AaIYt6-FQB-JWzNuMXNI-waZE7GdYfOgtTdnqucy7wgcQ-&oe=680CC4F8&_nc_sid=5e03e0&mms3=true', '5+up8dL3sRmUNO/rqfiuXOQ25dTLHUQpxZ23tfUCmos=');
       //json_response($returndata);
    }
}
