<?php

namespace App;

class moderatorController
{
    function __construct()
    {
        // Verify CSFR
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (! app('csfr')->verifyToken(SECRET_KEY)) {
                header('HTTP/1.0 403 Forbidden');
                exit();
            }
        }

        if (app('auth')->isAuthenticated()) {
            $logged_user = app('auth')->user(app('auth')->user()['id']);
            if ($logged_user['user_type'] != 4) {                                               //modifie user
                header("Location: " . route('logout'));
            }
        } else {
            //Debug
            //echo "<script>console.log('Debug Objects: AdminController@isnotAuthenticad' );</script>";
            //return json_response(['success' => "false", 'message' => __('login')]);
            //header("Location: " . route('login') . '?next=' . route('moderator-dashboard'));
        }
    }

    function check_user_type()
    {
        //Debug
        echo "<script>console.log('Debug Objects: AdminController@check_user_type' );</script>";
        $logged_user = app('auth')->user(app('auth')->user()['id']);
        if ($logged_user['user_type'] != 4) {
            return json_response(["success" => false], 200);
        } else {
            return json_response(["success" => true], 200);
        }
    }

    function index()
    {
        //return json_response(['success' => "false", 'message' => __('Video Calling Settings issue')]);
        $data = array();
        $data['users_count'] = app('db')->getValue('users', 'count(*)');
        $data['chatroom_count'] = app('db')->getValue('chat_rooms', 'count(id)');
        $data['private_chats_count'] = app('db')->getValue('private_chats', 'count(id)');
        $data['group_chats_count'] = app('db')->getValue('group_chats', 'count(id)');

        app('db')->orderBy("id", "desc");
        $chat_rooms_list = app('db')->get('chat_rooms', array(0, 10));
        $chat_rooms = array();
        foreach ($chat_rooms_list as $chat_room) {
            app('db')->join("chat_groups cg", "cg.id=gu.chat_group", "LEFT");
            app('db')->where('cg.chat_room', $chat_room['id']);
            app('db')->where('cg.slug', 'general');
            app('db')->get('group_users gu', null, 'gu.*');
            $chat_room['users_count'] = app('db')->count;
            array_push($chat_rooms, $chat_room);
        }
        $data['latest_rooms'] = $chat_rooms;

        app('db')->where('user_type', array(1, 2), 'IN');
        app('db')->orderBy("id", "desc");
        $user_list = app('db')->get('users', array(0, 10));
        $users = array();
        foreach ($user_list as $each_user) {
            $each_user['avatar_url'] = getUserAvatarURL($each_user);
            array_push($users, $each_user);
        }
        $data['latest_users'] = $users;
        $data['lang_list'] = app('db')->get('languages');

        //Debug
        //echo "<script>console.log('Debug Objects: Aqui' );</script>";

        echo app('twig')->render('moderator/index.html', $data);
    }

    // load index admin_js file
    public function moder_js()
    {
        header("Content-Type: text/javascript");
        echo app('twig')->render('moder/js/moder.js');
    }

    function ip_logs_data()
    {
        if (app('auth')->user()['user_type'] == 1) {
            $post_data = $_POST;

            $draw = app('purify')->xss_clean($post_data['draw']);
            $row = app('purify')->xss_clean($post_data['start']);
            $row_per_page = app('purify')->xss_clean($post_data['length']); // Rows display per page
            $column_index = app('purify')->xss_clean($post_data['order'][0]['column']); // Column index
            $column_name = app('purify')->xss_clean($post_data['columns'][$column_index]['data']); // Column name
            $column_sort_order = app('purify')->xss_clean($post_data['order'][0]['dir']); // asc or desc
            $search_value = app('purify')->xss_clean($post_data['search']['value']); // Search value
            $table = 'cn_ip_logs';

            ## Search
            $search_query = " ";
            if ($search_value != '') {
                $search_query = " and (email like '%" . $search_value . "%' or
                    ip like '%" . $search_value . "%' or message like '%" . $search_value . "%') ";
            }

            if (array_key_exists("log_type", $post_data)) {
                $search_type = app('purify')->xss_clean($post_data['log_type']);
                if ($search_type != "") {
                    $search_query .= " AND type = '" . $search_type . "' ";
                }
            }

            ## Total number of records without filtering
            $all_count_q = "SELECT COUNT(*) AS allcount FROM cn_ip_logs";
            $all_count_data = app('db')->rawQuery($all_count_q);
            $total_records = $all_count_data[0]['allcount'];

            ## Total number of record with filtering
            $all_filtered_count_q = "SELECT COUNT(*) as allcount FROM cn_ip_logs WHERE 1 " . $search_query;
            $all_filtered_count_data = app('db')->rawQuery($all_filtered_count_q);
            $total_filtered_records = $all_filtered_count_data[0]['allcount'];

            ## Fetch records
            $records_q = "SELECT * FROM cn_ip_logs WHERE 1 " . $search_query . " order by " . $column_name . " " . $column_sort_order . " limit " . $row . "," . $row_per_page;
            $all_data = app('db')->rawQuery($records_q);

            $return_data = array();
            foreach ($all_data as $key => $value) {
                if ($value['type'] == 1) {
                    $log_type = "Login";
                } elseif ($value['type'] == 2) {
                    $log_type = "Register";
                } elseif ($value['type'] == 3) {
                    $log_type = "Password Resets";
                } elseif ($value['type'] == 4) {
                    $log_type = "Logout";
                } else {
                    $log_type = "--";
                }

                $return_data[] = array(
                    "ip" => $value['ip'],
                    "country" => $value['country'],
                    "device" => user_agent_string($value['user_agent']),
                    "email" => $value['email'],
                    "time" => $value['time'],
                    "type" => $log_type,
                    "message" => $value['message']
                );
            }

            ## Response
            $response = array(
                "draw" => intval($draw),
                "iTotalRecords" => $total_records,
                "iTotalDisplayRecords" => $total_filtered_records,
                "aaData" => $return_data
            );
            echo json_encode($response);
        } else {
            header("Location: " . route('dashboard'));
        }
    }

    function flaged_content_data()
    {
        if (app('auth')->user()['user_type'] == 1) {
            $post_data = $_POST;

            $draw = app('purify')->xss_clean($post_data['draw']);
            $row = app('purify')->xss_clean($post_data['start']);
            $row_per_page = app('purify')->xss_clean($post_data['length']); // Rows display per page
            $column_index = app('purify')->xss_clean($post_data['order'][0]['column']); // Column index
            $column_name = app('purify')->xss_clean($post_data['columns'][$column_index]['data']); // Column name
            $column_sort_order = app('purify')->xss_clean($post_data['order'][0]['dir']); // asc or desc
            $search_value = app('purify')->xss_clean($post_data['search']['value']); // Search value
            $table = 'cn_reports';

            ## Search
            $search_query = " ";
            // if($search_value != ''){
            //     $search_query = " and (email like '%".$search_value."%' or
            //         ip like '%".$search_value."%' or message like '%".$search_value."%') ";
            // }

            if (array_key_exists("report_type", $post_data)) {
                $search_type = app('purify')->xss_clean($post_data['report_type']);
                if ($search_type != "") {
                    $search_query .= " AND report_type = '" . $search_type . "' ";
                }
            }

            if (array_key_exists("report_status", $post_data)) {
                $report_status = app('purify')->xss_clean($post_data['report_status']);
                if ($report_status != "") {
                    $search_query .= " AND status = '" . $report_status . "' ";
                }
            }

            ## Total number of records without filtering
            $all_count_q = "SELECT COUNT(*) AS allcount FROM cn_reports";
            $all_count_data = app('db')->rawQuery($all_count_q);
            $total_records = $all_count_data[0]['allcount'];

            ## Total number of record with filtering
            $all_filtered_count_q = "SELECT COUNT(*) as allcount FROM cn_reports WHERE 1 " . $search_query;
            $all_filtered_count_data = app('db')->rawQuery($all_filtered_count_q);
            $total_filtered_records = $all_filtered_count_data[0]['allcount'];

            ## Fetch records
            $records_q = "SELECT r.id, r.report_type, r.report_reason, r.reported_at, r.status, rs.title FROM cn_reports r, cn_report_reasons rs WHERE r.report_reason=rs.id " . $search_query . " order by " . $column_name . " " . $column_sort_order . " limit " . $row . "," . $row_per_page;
            $all_data = app('db')->rawQuery($records_q);

            $return_data = array();
            foreach ($all_data as $key => $value) {
                $value['title'] = get_default_term($value['title']);
                $return_data[] = $value;
            }

            ## Response
            $response = array(
                "draw" => intval($draw),
                "iTotalRecords" => $total_records,
                "iTotalDisplayRecords" => $total_filtered_records,
                "aaData" => $return_data
            );
            echo json_encode($response);
        } else {
            header("Location: " . route('dashboard'));
        }
    }

    function user_list_data()
    {
        if (app('auth')->user()['user_type'] == 4) {
            $post_data = $_POST;

            $draw = app('purify')->xss_clean($post_data['draw']);
            $row = app('purify')->xss_clean($post_data['start']);
            $row_per_page = app('purify')->xss_clean($post_data['length']); // Rows display per page
            $column_index = app('purify')->xss_clean($post_data['order'][0]['column']); // Column index
            $post_column_data = app('purify')->xss_clean($post_data['columns'][$column_index]['data']); // Column data
            $post_column_name = app('purify')->xss_clean($post_data['columns'][$column_index]['name']); // Column name
            if ($post_column_name) {
                $column_name = $post_column_name;
            } else if ($post_column_data) {
                $column_name = $post_column_data;
            } else {
                $column_name = 'id';
            }
            $column_sort_order = app('purify')->xss_clean($post_data['order'][0]['dir']); // asc or desc
            $search_value = app('purify')->xss_clean($post_data['search']['value']); // Search value

            ## Search
            $search_query = " ";
            if ($search_value != '') {
                $search_query = " and (email like '%" . $search_value . "%' or
                    user_name like '%" . $search_value . "%' or first_name like '%" . $search_value . "%') ";
            }

            if (array_key_exists("user_type", $post_data)) {
                $user_type = app('purify')->xss_clean($post_data['user_type']);
                if ($user_type != "") {
                    $search_query .= " AND user_type = '" . $user_type . "' ";
                } else {
                    $search_query .= " AND user_type IN (1, 2, 4)";
                }
            }

            if (array_key_exists("available_status", $post_data)) {
                $available_status = app('purify')->xss_clean($post_data['available_status']);
                if ($available_status != "") {
                    $search_query .= " AND available_status = '" . $available_status . "' ";
                }
            }

            ## Total number of records without filtering
            $all_count_q = "SELECT COUNT(*) AS allcount FROM cn_users WHERE user_type IN (1, 2, 4)";
            $all_count_data = app('db')->rawQuery($all_count_q);
            $total_records = $all_count_data[0]['allcount'];

            ## Total number of record with filtering
            $all_filtered_count_q = "SELECT COUNT(*) as allcount FROM cn_users WHERE 1 " . $search_query;
            $all_filtered_count_data = app('db')->rawQuery($all_filtered_count_q);
            $total_filtered_records = $all_filtered_count_data[0]['allcount'];

            ## Fetch records
            $records_q = "SELECT * FROM cn_users WHERE 1 " . $search_query . " order by " . $column_name . " " . $column_sort_order . " limit " . $row . "," . $row_per_page;
            $all_data = app('db')->rawQuery($records_q);

            $return_data = array();
            foreach ($all_data as $key => $value) {
                $return_data[] = $value;
            }

            ## Response
            $response = array(
                "draw" => intval($draw),
                "iTotalRecords" => $total_records,
                "iTotalDisplayRecords" => $total_filtered_records,
                "aaData" => $return_data
            );
            echo json_encode($response);
        } else {
            header("Location: " . route('moderator-dashboard'));
        }
    }

    function chatroom_list()
    {
        $data = array();
        $chat_rooms_list = app('db')->get('chat_rooms');
        $chat_rooms = array();
        foreach ($chat_rooms_list as $chat_room) {
            app('db')->join("chat_groups cg", "cg.id=gu.chat_group", "LEFT");
            app('db')->where('cg.chat_room', $chat_room['id']);
            app('db')->where('cg.slug', 'general');
            app('db')->get('group_users gu', null, 'gu.*');
            $chat_room['users_count'] = app('db')->count;
            array_push($chat_rooms, $chat_room);
        }
        $data['chat_rooms'] = $chat_rooms;
        $data['lang_list'] = app('db')->get('languages');
        echo app('twig')->render('moderator/chatroom_list.html', $data);
    }

    function general()
    {
        $data = array();
        app('db')->where('status', 1);
        app('db')->where('is_visible', 1);
        $data['chatroom_list'] = app('db')->get('chat_rooms');
        $data['lang_list'] = app('db')->get('languages');
        $data['timezone_list'] = get_timezone_list(SETTINGS['timezone']);
        $data['lang_list'] = app('db')->get('languages');
        echo app('twig')->render('moderator/general.html', $data);
    }

    function user_list()
    {
        $data['lang_list'] = app('db')->get('languages');
        echo app('twig')->render('moderator/user_list.html', $data);
    }

    function integration()
    {
        /* $data['lang_list'] = app('db')->get('languages'); */
        echo app('twig')->render('moderator/integration.html');
    }
}
