<?php
use  GuzzleHttp\Client ;

class DecryptAPI {

    function decryptImage($fileurl, $filekey){
        $formdata = [ 'form_params' => 
                [
                'fileurl'     => $fileurl,
                'filekey' => $filekey ,
                'filetype'  => 'jpg'
                ]
            ];
        $file = app('deczap')->processDecrypt($formdata);
        if (is_null($file)) return null;
        $file_name = basename(parse_url($file, PHP_URL_PATH));
        if (is_null($file_name)) return null;
        $image_file= app('deczap')->downloadFile($file,$file_name);
        $ex_file_name = explode(".", $file_name);
        $image_new = new ImageResize($image_file);
        $image_name = "dl-" . date('d-m-Y-') . substr($ex_file_name[0],4) . "_" . $image_new->getDestWidth() . "x" . $image_new->getDestHeight() . "." . $ex_file_name[1];
        copy($image_file, "media/chats/images/large/". $image_name);
        // save medium image
        $medium_image = "media/chats/images/medium/". $image_name;
        if(copy($image_file, $medium_image)){
            $medium_image_crop = new ImageResize($medium_image);
            $medium_image_crop->crop(300, 300);
            $medium_image_crop->save($medium_image);
        }
        // save thumb image
        $thumb_image = "media/chats/images/thumb/". $image_name;
        if(copy($image_file, $thumb_image)){
            $thumb_image_crop = new ImageResize($thumb_image);
            $thumb_image_crop->crop(220, 220);
            $thumb_image_crop->save($thumb_image);
        }
        unlink($image_file);
        return $image_name;
    }

    function decryptVideo($fileurl, $filekey){
        $formdata = [ 'form_params' => 
                [
                'fileurl'     => $fileurl,
                'filekey' => $filekey ,
                'filetype'  => 'mp4'
                ]
            ];
        $file = app('deczap')->processDecrypt($formdata);
        if (is_null($file)) return null;
        $file_name = basename(parse_url($file, PHP_URL_PATH));
        if (is_null($file_name)) return null;
        $video_file= app('deczap')->downloadFile($file,$file_name);
        $video_name = "dl-" . date('d-m-Y-') . $file_name;
        copy($video_file, "media/chats/videos/". $video_name);
        unlink($video_file);
        return $video_name;
    }
    function decryptAudio($fileurl, $filekey){
        $formdata = [ 'form_params' => 
                [
                'fileurl'     => $fileurl,
                'filekey' => $filekey ,
                'filetype'  => 'mp3'
                ]
            ];
        $file = app('deczap')->processDecrypt($formdata);
        if (is_null($file)) return null;
        $file_name = basename(parse_url($file, PHP_URL_PATH));
        if (is_null($file_name)) return null;
        $video_file= app('deczap')->downloadFile($file,$file_name);
        $video_name = "dl-" . date('d-m-Y-') . $file_name;
        copy($video_file, "media/chats/audio/". $video_name);
        unlink($video_file);
        return $video_name;
    }
    function decryptDocument($fileurl, $filekey, $filename) {
        $begin_name = str_replace('.', '-', substr($filename, 0 , strrpos($filename,'.')));
        $extension = substr($filename,strrpos($filename,'.') +1);
        $formdata = [ 'form_params' => 
                [
                'fileurl'     => $fileurl,
                'filekey' => $filekey ,
                'filetype'  => $extension
                ]
            ];
        $file = app('deczap')->processDecrypt($formdata);
        if (is_null($file)) return null;
        $file_name = basename(parse_url($file, PHP_URL_PATH));
        if (is_null($file_name)) return null;
        $doc_file= app('deczap')->downloadFile($file,$file_name);
        $doc_name = $begin_name . ".file-" . date('d-m-Y-') . $file_name;
        copy($doc_file, "media/chats/files/". $doc_name);
        unlink($doc_file);
        return $doc_name;
    }

    function downloadFile($file, $file_name){
        $guzclient = new Client();
        $dlfile = 'media/chats/files/' . $file_name;
        $guzclient->request('GET', $file, ['sink' => $dlfile]);
        if (file_exists($dlfile)) {
            return  $dlfile;
        } else {
            $error = [
                'log_type' => 'error',
                'download' => $file,
                'time' => date('d-m-Y H:i:s'),
                'error' => $guzclient,
                'file_name' => $dlfile
            ];
            apendinlog(json_encode($error), "deczap");
            return null;
        }
    }

    function processDecrypt($formdata){
        $guzclient = new Client();
        $resp = $guzclient->request('POST', SETTINGS['zapdecrypt_url'], $formdata );
        $jresponse = json_decode($resp->getBody());
        if (isset($jresponse->error)){
            $error = [
                'log_type' => 'error',
                'decoderurl' => SETTINGS['zapdecrypt_url'],
                'time' => date('d-m-Y H:i:s'),
                'error' => $jresponse,
                'input_data' => $formdata
            ];
            apendinlog(json_encode($error), "deczap");
            return null;
        }
        return $jresponse->file;
    }
}