<?php

/* ZapMessage class for script Whatsapp Messages*/
use  JoyPixels\Client ;
use  JoyPixels\Ruleset ;
class ZapMessage {


    function normalizeBRNumber($number) {
        $filtered = preg_replace("/[^0-9]/", "", $number);
        if ( strlen($filtered) >= 12 ) {
            if ( substr($filtered, 0, 2) == "55" ) {
                if ( strlen($filtered) == 13 ){
                    return($filtered);
                } elseif (strlen($filtered) == 12 ) {
                        return(substr($filtered, 0, 4) . "9" . substr($filtered, 4, 8));
                } else return($filtered);
            } else return($filtered);
        } 
    }
    
    function getRoomId($number) {
        app('db')->where('slug', $number);
        $chatroomid = app('db')->getOne('chat_rooms');
        if (!$chatroomid) {
            return 0;
        }else{
            return $chatroomid['id'];
        }
    }
    function getGroupId($roomid) {
        app('db')->where('chat_room', $roomid);
        $chatgroupid = app('db')->getOne('chat_groups');
        if (!$chatgroupid) {
            return 0;
        }else{
            return $chatgroupid['id'];
        }
    }
    function getZapNumber($roomid) {
        app('db')->where('id', $roomid);
        $chatgroupid = app('db')->getOne('chat_rooms');
        if (!$chatgroupid) {
            return 0;
        }else{
            return $chatgroupid['slug'];
        }
    }
    function getUserName($userid) {
        app('db')->where('id', $userid);
        $chatgroupid = app('db')->getOne('users');
        if (!$chatgroupid) {
            return "No Name";
        }else{
            return $chatgroupid['first_name'] . " " . $chatgroupid['last_name'];
        }
    }   

    function processTextMessage($messagedata){
        $roomid = app('zapmsg')->getRoomId($messagedata['number']);
        app('db')->where('room_id', $roomid);
        app('db')->where('message_id', $messagedata['message-id']);
        $client = new Client(new Ruleset());
        $isadded = app('db')->getOne('group_chats');
        if (!$isadded) {
            $groupid = app('zapmsg')->getGroupId($roomid);
            $data = Array ("sender_id" => $messagedata['localID'],
                            "group_id" => $groupid,
                            "room_id" => $roomid,
                            "whats_id" => $messagedata['number'],
                            "message_id" => $messagedata['message-id'],
                            "type" => 1,
                            "message" => $client->toShort($messagedata['message']),
                            "status" => 1,
                            "time" => $messagedata['date-time'],
                            "updated_at" => $messagedata['date-time'],
                        );
            $id = app('db')->insert ('group_chats', $data);
            app('db')->where('id', $id);
            $chat_data = app('db')->getOne('group_chats');
        }
    }
    function processImageMessage($messagedata){
        $roomid = app('zapmsg')->getRoomId($messagedata['number']);
        app('db')->where('room_id', $roomid);
        app('db')->where('message_id', $messagedata['message-id']);
        $isadded = app('db')->getOne('group_chats');
        if (!$isadded) {
            $groupid = app('zapmsg')->getGroupId($roomid);
            $image_name = app('deczap')->decryptImage($messagedata['imageurl'], $messagedata['imagekey']);
            $message =[
                'content' => [$image_name],
                'caption'=>  $messagedata['caption'] ?? ''
            ];
            $data = Array ("sender_id" => $messagedata['localID'],
                            "group_id" => $groupid,
                            "room_id" => $roomid,
                            "whats_id" => $messagedata['number'],
                            "message_id" => $messagedata['message-id'],
                            "type" => 2,
                            "message" => json_encode($message),
                            "status" => 1,
                            "time" => $messagedata['date-time'],
                            "updated_at" => $messagedata['date-time'],
                        );
            $id = app('db')->insert ('group_chats', $data);
            app('db')->where('id', $id);
            $chat_data = app('db')->getOne('group_chats');
        }

    }
    function processVideoMessage($messagedata){ 
        $roomid = app('zapmsg')->getRoomId($messagedata['number']);
        app('db')->where('room_id', $roomid);
        app('db')->where('message_id', $messagedata['message-id']);
        $isadded = app('db')->getOne('group_chats');
        if (!$isadded) {
            $groupid = app('zapmsg')->getGroupId($roomid);
            $video_name = app('deczap')->decryptVideo($messagedata['videourl'], $messagedata['videokey']);
            file_put_contents('media/chats/videos/' . $video_name . '-.jpg', base64_decode($messagedata['thumbjpg']));
            $message =[
                'content' => [ 0 =>  [
                        'name' => $video_name,
                        'extension' => substr($messagedata['mimetype'],-3),
                        'size' => app('chat')->humanFileSize($messagedata['filelength']),
                        'thumbnail' => $video_name . '-.jpg',
                        'duration' => $messagedata['videosec']
                    ],
                ],
                'caption'=>  $messagedata['caption'] ?? ''
            ];
            $data = Array ("sender_id" => $messagedata['localID'],
                            "group_id" => $groupid,
                            "room_id" => $roomid,
                            "whats_id" => $messagedata['number'],
                            "message_id" => $messagedata['message-id'],
                            "type" => 11,
                            "message" => json_encode($message),
                            "status" => 1,
                            "time" => $messagedata['date-time'],
                            "updated_at" => $messagedata['date-time'],
                        );
            $id = app('db')->insert ('group_chats', $data);
            app('db')->where('id', $id);
            $chat_data = app('db')->getOne('group_chats');
        }
    }
    function processAudioMessage($messagedata){
        $roomid = app('zapmsg')->getRoomId($messagedata['number']);
        app('db')->where('room_id', $roomid);
        app('db')->where('message_id', $messagedata['message-id']);
        $isadded = app('db')->getOne('group_chats');
        if (!$isadded) {
            $groupid = app('zapmsg')->getGroupId($roomid);
            $audio_name = app('deczap')->decryptAudio($messagedata['audiourl'], $messagedata['audiokey']);
            $message =[
                'name' => $audio_name,
                'extension' => 'mp3',
                'size' => app('chat')->humanFileSize($messagedata['filelength']),
                'duration' => gmdate("i:s", $messagedata['audiosec'])
            ];
            $data = Array ("sender_id" => $messagedata['localID'],
                            "group_id" => $groupid,
                            "room_id" => $roomid,
                            "whats_id" => $messagedata['number'],
                            "message_id" => $messagedata['message-id'],
                            "type" => 7,
                            "message" => json_encode($message),
                            "status" => 1,
                            "time" => $messagedata['date-time'],
                            "updated_at" => $messagedata['date-time'],
                        );
            $id = app('db')->insert ('group_chats', $data);
            app('db')->where('id', $id);
            $chat_data = app('db')->getOne('group_chats');
        }
    }
    function processDocumentMessage($messagedata){
        $roomid = app('zapmsg')->getRoomId($messagedata['number']);
        app('db')->where('room_id', $roomid);
        app('db')->where('message_id', $messagedata['message-id']);
        $isadded = app('db')->getOne('group_chats');
        if (!$isadded) {
            $groupid = app('zapmsg')->getGroupId($roomid);
            $file_name = app('deczap')->decryptDocument($messagedata['fileurl'], $messagedata['filekey'], $messagedata['filename']);
            $message =[ 'content' => [ 0 => [
                    'name' => $file_name,
                    'extenstion' => substr($messagedata['filename'],strrpos($messagedata['filename'],'.') +1),
                    'size' => app('chat')->humanFileSize($messagedata['filelength'])
                ], ],
                'caption' => ''
            ];
            $data = Array ("sender_id" => $messagedata['localID'],
                            "group_id" => $groupid,
                            "room_id" => $roomid,
                            "whats_id" => $messagedata['number'],
                            "message_id" => $messagedata['message-id'],
                            "type" => 6,
                            "message" => json_encode($message),
                            "status" => 1,
                            "time" => $messagedata['date-time'],
                            "updated_at" => $messagedata['date-time'],
                        );
            $id = app('db')->insert ('group_chats', $data);
            app('db')->where('id', $id);
            $chat_data = app('db')->getOne('group_chats');
        }
    }
    function sendTextMessage($messagedata){
        $number = app('zapmsg')->normalizeBRNumber(app('zapmsg')->getZapNumber($messagedata['room_id']));
        $message = "";
        $client = new Client(new Ruleset());
        if (!isJson($messagedata['message'])){
            if (isset(SETTINGS['zap_signature']) && SETTINGS['zap_signature'] == true ) {
                $sendername = app('zapmsg')->getUserName($messagedata['sender_id']);
                $message = "*" . $sendername . "*: \r\n" . $client->shortnameToUnicode($messagedata['message']);
            } else {
                $message = $client->shortnameToUnicode($messagedata['message']);
            }
            $post = app('evoapi')->postTextMessage(['number' => $number, 'message' => $message]);
        } else {
            $jsondata = json_decode($messagedata['message']);
            switch ($messagedata['type']){
                case 11:
                    $post = app('evoapi')->postVideo(['number' => $number, 'video' => MEDIA_URL . '/chats/videos/' . $jsondata->content[0]->name, 'caption' => $jsondata->caption]);
                    break;
                case 2:
                    $post = app('evoapi')->postImage(['number' => $number, 'image' => MEDIA_URL . '/chats/images/large/' . $jsondata->content[0], 'caption' => $jsondata->caption ]);
                    break;
                case 7:
                    $post = app('evoapi')->postAudio(['number' => $number, 'audio' => MEDIA_URL . '/chats/audio/' . $jsondata->name]);
                    break;
                case 6:
                    $post = app('evoapi')->postDocument(['number' => $number, 'document' => MEDIA_URL . '/chats/files/' . $jsondata->content[0]->name, 'name' => $jsondata->content[0]->name, 'caption' => $jsondata->caption]);
                    break;

            }
            
        }
    }
}
